



<html>
<head>
  <title>javabog.dk -  - Lokale, objekt- og klassevariabler</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel6.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel8.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">7 <a name='afsn7'></a>Lokale,
objekt- og klassevariabler</H1>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI VALUE=1><P LANG="da-DK" CLASS="kapiteloversigt-western">Klassevariable</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Repetition af
  objektvariabler og lokale variabler</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Rekursion</P>
</UL>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Foruds&aelig;ttes
ikke i resten af bogen.</P>
<P LANG="da-DK" CLASS="kapiteloversigt-western"><SPAN STYLE="font-weight: medium">Foruds&aelig;tter</SPAN>
<a href='kapitel4.jsp'>kapitel 4</a>, Definition af klasser.</P>


<P LANG="da-DK" CLASS="western" STYLE="">De
variabler, vi er st&oslash;dt p&aring; indtil nu, har enten v&aelig;ret
lokale variabler eller objektvariabler.</P>
<P LANG="da-DK" CLASS="western">Objektvariabler hedder s&aring;dan,
fordi de bliver oprettet for hvert objekt.</P>
<P LANG="da-DK" CLASS="western">Der findes ogs&aring; variabler, der
eksisterer &quot;i klassen&quot;, uafh&aelig;ngigt af om der bliver
oprettet objekter. Disse kaldes <I>klassevariabler</I> og erkl&aelig;res
med n&oslash;gleordet <B>static</B> (derfor kaldes de ofte ogs&aring;
for &quot;statiske variabler&quot;).</P>
<H2 CLASS="western">7.1 <a name='afsn7.1'></a>Klassevariabler og -metoder</SPAN></H2>
<P LANG="da-DK" CLASS="western">Herunder ses et eksempel p&aring; en
klassevariabel og en klassemetode (<SPAN STYLE="font-style: normal">antalBo</SPAN>kse).
</P>
<P LANG="da-DK" CLASS="western" STYLE="; ">
Klassevariabler og -metoder vises med understregning i UML-notationen
(diagrammet til h&oslash;jre).</P>
<PRE CLASS="kode-western" STYLE="">public class Boks4 <IMG SRC="bog8_html_m5fd300c.gif" NAME="Objekt25" ALIGN=LEFT>
{
  private double l&aelig;ngde;              <I>// objektvariabel</I>
  private double bredde;              <I>// objektvariabel</I>
  private double h&oslash;jde;               <I>// objektvariabel</I>
<B>  private static int antalBokse;      </B><I><SPAN STYLE="font-weight: medium">// klassevariabel</SPAN></I>

  public Boks4(double lgd, double b, double h)
  {
<I>    // lgd, b og h er lokale variabler</I>
    l&aelig;ngde = lgd;
    bredde = b;
    h&oslash;jde  = h;
    antalBokse = antalBokse + 1;
  }

<B>  public static int l&aelig;sAntalBokse()   </B><I><SPAN STYLE="font-weight: medium">// klassemetode</SPAN></I>
  {
    return antalBokse;
  }

  public double volumen()
  {
<I>    // vol er en lokal variabel</I>
    double vol;
    vol = l&aelig;ngde*bredde*h&oslash;jde;
    return vol; 
  }
}</PRE><P LANG="da-DK" CLASS="western" STYLE="">
Variablen <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">antalBokse</SPAN></SPAN></FONT></FONT>
er en klassevariabel, fordi den er erkl&aelig;ret med n&oslash;gleordet
static. Dette betyder, at variablen er tilknyttet klassen og at alle
Boks-objekter deler den samme variabel. Der vil eksistere &eacute;n
og kun &eacute;n <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">antalBokse</SPAN></SPAN></FONT></FONT>-variabel,
uanset om der oprettes 0, 1, 2 eller 100 Boks-objekter. 
</P>
<P LANG="da-DK" CLASS="western">Ligeledes er metoden l&aelig;sAntalBokse()
en klassemetode, da den er erkl&aelig;ret med n&oslash;gleordet
static. Den arbejder p&aring; klasseniveau (uafh&aelig;ngigt af
om der er skabt nogen objekter) og kan derfor ikke anvende metoder og
variabler i klassen, der eksisterer p&aring; objektnivau. Det er
f.eks. forbudt at bruge variablerne <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">l&aelig;ngde</SPAN></SPAN></FONT></FONT>,
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">bredde</SPAN></SPAN></FONT></FONT>
eller <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">h&oslash;jde</SPAN></SPAN></FONT></FONT>
inde fra l&aelig;sAntalBokse().</P>
<P LANG="da-DK" CLASS="western">Inde fra objektet kan klassevariabler
(og -metoder) bruges ligesom almindelige variabler og -metoder. Det
ses f.eks. i konstrukt&oslash;ren:</P>
<PRE CLASS="kode-western">    antalBokse = antalBokse + 1;</PRE>
<P LANG="da-DK" CLASS="western">Og for fuldst&aelig;ndighedens skyld:
Variablerne <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">l&aelig;ngde</SPAN></SPAN></FONT></FONT>,
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">bredde</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">h&oslash;jde</SPAN></SPAN></FONT></FONT>
er &quot;normale&quot; objektvariabler, s&aring; hvert Boks-objekt
har tilknyttet &eacute;n af hver. Variablen <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">vol</SPAN></SPAN></FONT></FONT>
er en lokal variabel, fordi den er erkl&aelig;ret lokalt i
volumen-metoden og alts&aring; kun eksisterer, n&aring;r
volumen-metoden udf&oslash;res. Ligeledes med <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">lgd</SPAN></SPAN></FONT></FONT>,
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">b</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">h</SPAN></SPAN></FONT></FONT>:
De eksisterer kun i Boks' konstrukt&oslash;r.</P>
<P LANG="da-DK" CLASS="western" STYLE="">Vi
kan afpr&oslash;ve Boks4 med:</P>
<PRE CLASS="kode-western">public class BenytBoks4
{
  public static void main(String[] arg)
  {
    System.out.println(&quot;Antal bokse: &quot;+ <B>Boks4.l&aelig;sAntalBokse()</B>);

    Boks4 boksen;
    boksen = new Boks4(2,5,10);

    System.out.println(&quot;Antal bokse: &quot;+ <B>Boks4.l&aelig;sAntalBokse()</B>);

    Boks4 enAndenBoks, enTredjeBoks;
    enAndenBoks = new Boks4(5,5,10);
    enTredjeBoks = new Boks4(7,5,10);

    System.out.println(&quot;Antal bokse: &quot;+ <B>Boks4.l&aelig;sAntalBokse()</B>);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Antal bokse: 0
Antal bokse: 1
Antal bokse: 3</PRE><P LANG="da-DK" CLASS="western">
Det ses, at vi udefra kan kalde klassemetoder ved bare at angive
klassenavnet og metodenavnet som i Boks4.l&aelig;sAntalBokse(). Havde
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">antalBokse</SPAN></SPAN></FONT></FONT>
v&aelig;ret tilg&aelig;ngelig udefra (f.eks. erkl&aelig;ret public i
stedet for private), kunne vi f&aring; fat i den udefra med:
Boks4.antalBokse.</P>
<P LANG="da-DK" CLASS="western">V&aelig;r opm&aelig;rksom p&aring;,
at det normalt frar&aring;des at definere mange klassevariabler og
-metoder i ens program, da det kan g&oslash;re programmet sv&aelig;rt
at gennemskue og &oslash;ger de enkelte klassers afh&aelig;ngighed af
hinanden (h&oslash;j kobling). Endelig kan det friste folk til at
springe &quot;alt det besv&aelig;rlige med objekter&quot; over og
dermed ikke f&aring; l&aelig;rt eller udnyttet mulighederne i
objektorienteret programmering.</P>
<H3 CLASS="western">7.1.1 <a name='afsn7.1.1'></a>Eksempler p&aring; klassevariabler</H3>
<P LANG="da-DK" CLASS="western">Du har, m&aring;ske uden at vide det,
allerede brugt en del klassevariabler og -metoder. 
</P>
<P LANG="da-DK" CLASS="western">Der er mange <SPAN STYLE="font-weight: medium">klassevariabler</SPAN><B>
</B>i Javas standardbibliotek. Af de oftest brugte kan n&aelig;vnes</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">Matematiske konstanter som
  Math.PI (v&aelig;rdien af <FONT FACE="Symbol"></FONT>er
  klassevariabler i Math-klassen.</P>
  <LI><P LANG="da-DK" CLASS="western">Foruddefinerede farver som
  Color.BLACK - et Color-objekt, der repr&aelig;senterer farven sort.
  Objektet ligger som en klassevariabel i (selvsamme)
  Color-klasse (pakken java.awt).</P>
  <LI><P LANG="da-DK" CLASS="western">System.out - systemoutputtet er
  et PrintStream-objekt, der bl.a. har metoderne print() og println().
  Objektet er en klassevariabel i System-klassen.</P>
</UL>
<P LANG="da-DK" CLASS="western">Klassevariabler er nyttige til
variabler, der skal v&aelig;re tilg&aelig;ngelige overalt i
programmet. Det er det n&aelig;rmeste, man kommer globale variabler,
som det kendes fra andre programmeringssprog.</P>
<H3 CLASS="western">7.1.2 <a name='afsn7.1.2'></a>Eksempler p&aring; klassemetoder</H3>
<P LANG="da-DK" CLASS="western">Af nyttige <SPAN STYLE="font-weight: medium">klassemetoder</SPAN>
i standardbiblioteket kan n&aelig;vnes</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western" ALIGN=LEFT>Matematiske
  funktioner som Math.random(), Math.sin(double&nbsp;x),
  Math.cos(double&nbsp;x), Math.sqrt(double&nbsp;x),
  Math.abs(double&nbsp;x), Math.exp(double&nbsp;x),
  Math.log(double&nbsp;x), ...</P>
  <LI><P LANG="da-DK" CLASS="western">Double.parseDouble(String s)
  returnerer v&aelig;rdien af <I>s</I><SPAN STYLE="font-style: normal">
  som et kommatal. Nyttig til at fortolke brugerindtastede tal. F.eks.
  giver Double.parseDouble(&quot;3.553&quot;) tallet 3.553.</SPAN></P>
  <LI><P LANG="da-DK" CLASS="western"><SPAN STYLE="font-style: normal">Tilsvarende
  giver </SPAN>Integer.parseInt(String s) v&aelig;rdien af <I>s</I><SPAN STYLE="font-style: normal">
  som et heltal.</SPAN></P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="font-style: normal; ">
  String.valueOf(double d) g&oslash;r det modsatte af
  Double.parseDouble, den returnerer en streng, som repr&aelig;senterer
  et flydende kommatal. String.valueOf(3.21) giver alts&aring;
  strengen &quot;3.21&quot;. Findes ogs&aring; med int, byte, char
  etc. som parameter.</P>
  <LI><P LANG="da-DK" CLASS="western"><SPAN STYLE="font-style: normal">Character.isDigit(character
  t) returnerer true eller false, afh&aelig;ngigt af om tegnet </SPAN><I>t</I><SPAN STYLE="font-style: normal">
  er et ciffer. Ligeledes findes </SPAN>Character.isLetter(character
  t), Character.isLetterOrDigit(character t),
  <SPAN STYLE="font-style: normal">Character.isLowerCase(character t),
  Character.isUpperCase(character t) og
  Character.isWhitespace(character t). Den sidste unders&oslash;ger,
  om t er et usynligt </SPAN><SPAN STYLE="font-style: normal">skilletegn,
  f.eks. mellemrum, linjeskift, tabulator.</SPAN></P>
  <LI><P LANG="da-DK" CLASS="western">System.exit() - stopper
  programudf&oslash;relsen og afslutter Java.</P>
</UL>
<P LANG="da-DK" CLASS="western">Det vigtigste eksempel p&aring; en
klassemetode er main()-metoden, som du selv erkl&aelig;rer, n&aring;r
du skriver et program, f.eks. BenytBoks.main(). N&aring;r et program
startes, er det altid main(), der kaldes. P&aring; dette tidspunkt
eksisterer der endnu ingen objekter og derfor skal main() v&aelig;re
en klassemetode. Der skal jo aldrig oprettes nogen
BenytBoks-objekter!</P>
<P LANG="da-DK" CLASS="western">Klassemetoder er nyttige til
&quot;subrutiner&quot;, der skal regne et eller andet ud (ud fra
parametrene) og returnere resultatet. Et eksempel er vist i <a href='kapitel2.jsp#afsn2.12.4'>afsnit 2.12.4</a>,
Klassemetoder.</P>
<H2 CLASS="western">7.2 <a name='afsn7.2'></a>Lokale variabler og parametre</SPAN></H2>
<P LANG="da-DK" CLASS="western">N&aring;r en metode kaldes, opretter
systemet en &quot;omgivelse&quot; for det metodekald. I denne
omgivelse oprettes parametervariablerne og de lokale variabler.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En lokal variabel
er kendt fra dens erkl&aelig;ring og ned til slutningen af den blok,
der omslutter den</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Dette kaldes
variablens virkefelt</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Den lidt indviklede formulering
skyldes, at man kan lave variabler, der er lokale for en hvilken som
helst blok - ikke kun en metode-krop. Man kan alts&aring; skrive
noget som:</P>
<PRE CLASS="kode-western">  ...
  int a = 10;
  while (a &gt; 0)
  {
    double b; <I>// b erkl&aelig;res lokalt i while-blokken</I>
    b = Math.random();
    ...
    System.out.println(b);
    a--;
  }
  System.out.println(a);
  System.out.println(b); <I>// fejl: b eksisterer ikke, da vi er uden for blokken.</I>
...</PRE><P LANG="da-DK" CLASS="western">
Vi har desuden allerede set, at man i for-l&oslash;kker kan erkl&aelig;re
en variabel, der er lokal for l&oslash;kkens krop:</P>
<PRE CLASS="kode-western">  for (int i=0; i&lt;10; i++) 
    System.out.print(i);

  System.out.print(i); <I>// fejl: i eksisterer ikke uden for l&oslash;kken.</I></PRE><H3 CLASS="western">
7.2.1 <a name='afsn7.2.1'></a>Parametervariabler</H3>
<P LANG="da-DK" CLASS="western">Parametervariabler f&aring;r tildelt
en <I>kopi</I> af den v&aelig;rdi, de blev kaldt med og opf&oslash;rer
sig i &oslash;vrigt fuldst&aelig;ndigt som lokale variabler. Man kan
f.eks. godt tildele dem nye v&aelig;rdier:</P>
<PRE CLASS="kode-western" STYLE=""><I>  // metode, der udskriver et bestemt antal stjerner p&aring; sk&aelig;rmen.</I>
  public void udskrivStjerner(<B>int antal</B>)
  {
    while (antal&gt;0)
    {
      System.out.print(”*”);
      <B>antal = antal-1;</B> <I>// Det kan man godt (men det er d&aring;rlig stil)</I>
    }
    System.out.println();
  }

    ....
<B>    int stj = 10;</B>
<B>    udskrivStjerner(stj);</B> <I>// kald af udskrivStjerner</I>
<I><B>    // stj er stadig 10.</B></I></PRE><P LANG="da-DK" CLASS="western">
Kalderen m&aelig;rker intet til, at parametervariablen <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">antal</SPAN></SPAN></FONT></FONT>
har f&aring;et en ny v&aelig;rdi, fordi kalderens v&aelig;rdi netop
blev <I>kopieret</I> over i parametervariablen. 
</P>
<P LANG="da-DK" CLASS="western">Her skal man v&aelig;re opm&aelig;rksom
p&aring; forskellen mellem variabler af simple typer og variabler af
objekt-typer. Da det sidste er <I>referencer</I> (adresser p&aring;
objekter), peger parametervariablen p&aring; samme objekt som
kalderen, n&aring;r den bliver kopieret. &AElig;ndrer man i
objektet, sl&aring;r &aelig;ndringen ogs&aring; igennem hos kalderen.
</P>
<P LANG="da-DK" CLASS="western">Derfor kan flyt1() herunder godt
&aelig;ndre <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">y</SPAN></SPAN></FONT></FONT>
i kalderens punkt-objekt:</P>
<PRE CLASS="kode-western">import java.awt.*;
public class Parametervariabler
{
  public static void flyt1(Point p, int dx, int dy)
  {
    p.x = p.x+dx;  <I>// OK, vi &aelig;ndrer p&aring; kalderens objekt</I>
    p.y = p.y+dy;
  }

  public static void flyt2(Point p, int dx, int dy)
  {
<I>    // hmm... vi smider kalderens objekt v&aelig;k... men det opdager han ikke!</I>
    p = new Point(p.x+dx, p.y+dy);
  }

  public static void main(String[] arg)
  {
    Point p1 = new Point(10,10);
    flyt1(p1,13,14);
    System.out.println(&quot;Nu er p1=&quot;+p1);

    Point p2 = new Point(10,10);
    flyt2(p2,13,14);
    System.out.println(&quot;Nu er p2=&quot;+p2);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Nu er p1=java.awt.Point[x=23,y=24]
Nu er p2=java.awt.Point[x=10,y=10]</PRE><P LANG="da-DK" CLASS="western">
Vi kan ikke &aelig;ndre p&aring; kalderens reference, som vi fors&oslash;ger
p&aring; i flyt2(): En lokal variabel oprettes, n&aring;r man g&aring;r
ind i blokken, hvor den er defineret og nedl&aelig;gges igen, n&aring;r
blokken forlades. Der bliver oprettet en ny variabel, hver gang
programudf&oslash;relsen g&aring;r ind i blokken.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">N&aring;r en
metode kaldes, bliver der oprettet et nyt s&aelig;t lokale variabler
(incl. parametervariabler) uafh&aelig;ngigt af, hvilke metoder, der i
&oslash;vrigt kaldes eller er i gang med at blive kaldt</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Hvis en metode bliver kaldt to gange,
eksisterer der alts&aring; to versioner af den lokale variabel -
&eacute;n i hver deres omgivelse. Det beh&oslash;ver man som regel
ikke at t&aelig;nke p&aring;, men det er rart at have vished for, at
en anden metode ikke bare kan &aelig;ndre ens lokale variabler.</P>
<P LANG="da-DK" CLASS="western"><I>Rekursion</I> er en teknik, der
udnytter, at der bliver oprettet en ny omgivelse med nye lokale
variabler, hver gang en metode kaldes. Nogle problemer kan l&oslash;ses
meget elegant med rekursion. I Avanceret-afsnittet i slutningen af
kapitlet vises nogle eksempler p&aring; rekursion.</P>
<H2 CLASS="western">7.3 <a name='afsn7.3'></a>Test dig selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.3">
  <input type='checkbox' name='vis' value='7.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">7.4 <a name='afsn7.4'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.4">
  <input type='checkbox' name='vis' value='7.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">7.4.1 <a name='afsn7.4.1'></a>Tilknytning</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.4.1">
  <input type='checkbox' name='vis' value='7.4.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.4.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">7.4.2 <a name='afsn7.4.2'></a>Adgang til variabler og metoder</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.4.2">
  <input type='checkbox' name='vis' value='7.4.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.4.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
7.4.3 <a name='afsn7.4.3'></a>Adgang fra metoder</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.4.3">
  <input type='checkbox' name='vis' value='7.4.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.4.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<H2 CLASS="western" STYLE="">7.5 <a name='afsn7.5'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.5">
  <input type='checkbox' name='vis' value='7.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">7.5.1 <a name='afsn7.5.1'></a>Introduktion til rekursive algoritmer</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.5.1">
  <input type='checkbox' name='vis' value='7.5.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.5.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">7.5.2 <a name='afsn7.5.2'></a>Rekursion: Beregning af formel</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.5.2">
  <input type='checkbox' name='vis' value='7.5.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.5.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">7.5.3 <a name='afsn7.5.3'></a>Rekursion: Listning af filer</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.5.3">
  <input type='checkbox' name='vis' value='7.5.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.5.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western" STYLE="">7.5.4 <a name='afsn7.5.4'></a>Rekursion:
Tegning af fraktaler</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel7.jsp#afsn7.5.4">
  <input type='checkbox' name='vis' value='7.5.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.5.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel6.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel8.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (79% af vrket).
</font>
<br>
nsker du at se de sidste 21% af dette vrk (226970 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
